﻿#include Chrome.ahk
#include ImagePut.ahk

; ----------------------------------------------------------------------------------------
; 第1个参数是用户配置文件目录，也就是 User_Data 目录，或 "First Run" 文件所在位置。
  ; 当然，也可以像本例中一样，随便设置一个位置，这样就会用新的临时身份来打开 Chrome 。
; 第2个参数是初始打开的网址们，不填打开空白页。
; 第3个参数是自定义命令行参数，多个参数之间加空格。
  ; 无头模式:               "--headless"
  ; 浏览器标识:             "--user-agent=""标识内容"""
  ; 既设置无头模式又改标识: "--headless --user-agent=""标识内容"""
  ; 更多其它设置，自己去搜 Chrome 命令行参数。
; 第4个参数是 Chrome.exe 位置，不填会尝试在开始菜单和注册表里找。


ChromeInst := new Chrome("TempData",,,"D:\Program Files\centBrowser\chrome.exe")
tab := ChromeInst.GetPage()

tab.Url := "https://www.baidu.com/"         ; 打开百度
tab.WaitForLoad()                            ; 等待网页加载完成

ImagePutClipboard("E:\OneDrive\图片\eac4b74543a98226f10dabd38682b901.jpg")

tab.querySelector("span[class=soutu-btn]").click()

rect := tab.querySelector("div[class=soutu-drop]").getBoundingClientRect()
;MsgBox % rect.x "`n" rect.y

MouseClick, left, rect.x + 10, rect.y + 100

SendInput ^v

ExitApp

;tab.querySelector("span[class=soutu-drop-tip]").click()
;ChromeInst.Kill()
;tab.Disconnect()
;tab.Call("Browser.close")                                    ; 关闭浏览器(所有页面和标签)
;tab.Call("Page.navigate", {"url": "https://www.baidu.com/"})

; 对于使用 querySelector 或 querySelectorAll 等方法获取的元素
; 支持元素在 JS 中的全部属性与方法（注意：大小写必须与 JS 中的保持一致）
; 获取元素虽然支持 .getElementById() 等方法，但建议只用 .querySelector()
; 因为通过浏览器 -> 审查元素（开发者工具） -> Elements -> Copy -> Copy JS path
; 可以快速得到 .querySelector() 中需要填的内容
tab.querySelector("#hotsearch-refresh-btn").click()                             ; 调用元素的 js 方法，点击换一换按钮

元素集 := tab.querySelectorAll("li.hotsearch-item")                             ; 获取元素集
MsgBox % 元素集[1].textContent                                                   ; 读属性
MsgBox % 元素集[2].InnerHTML                                                     ; 读属性但失败，因为大小写错误
元素集[3].innerHTML := "写属性就是这么简单"                                      ; 写属性
MsgBox 注意看，第3条热搜被改了

tab.getElementById("kw").value := "我爱ahk 我爱KMCounter"                       ; 在搜索框中输入文字
tab.getElementById("su").click()                                                ; 点击搜索按钮
tab.WaitForLoad()                                                               ; 等待网页加载完成

while (!tab.getElementById("2"))                                                ; 等待元素出现
  Sleep 1000
MsgBox % tab.getElementById("2").innerText                                      ; 打印第二条搜索结果

tab.Evaluate("alert('看到了吧！\nahk 操控 Chrome 也是非常简单的！')")           ; 执行 JS 代码让 Chrome 弹一个提示框

; 这里用到的不是 JS ，而是 Chrome API 。
; https://chromedevtools.github.io/devtools-protocol/tot/Browser/
MsgBox % tab.Call("Browser.getVersion").userAgent                               ; 获取浏览器 userAgent

tab.Close()                                                                     ; 关闭tab

ExitApp


